﻿var theURL= "in_and_out.html";
var winName="";

var INT_DISP = 1;
var HEX_DISP = 2;

var PmtPidInt = new Array(2048);
var PmtPidHex = new Array(2048);
var PcrPidInt = new Array(2048);
var PcrPidHex = new Array(2048);
var stIndex = new Array(2048);


var NUM_COLUMNS = 14;
var NUM_COLUMNS_ERM = 8;
var INPUT_BUTTON = 13;
var BITRATE_INDEX = 11;

var PMT_PID = 9;
var PCR_PID = 10;

var g_RowCount = 1;
var g_OffSet = 0;
var g_RowCountErm = 0;
var g_OffSetErm = 0;

var card_index;//a
var port_index;//b
var channel_index;//c
var global_channel_index;//a/b.c

var DB_MPTS  = "MPTS";
var DB_DATA  = "Data";

var colWidth = new Array("55px","50px","95px","50px","95px","50px","75px","50px","60px","45px","45px","60px","50px","55px");
var colWidthErm = new Array("100px","100px","80px","80px","120px","80px","120px","90px");
var language;

function DelRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		table.deleteRow(g_RowCount);
		g_RowCount--; // row number after which the new is to be inserted. should be incremented
	}
}

function DelRowsErm(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		table.deleteRow(g_RowCountErm);
		g_RowCountErm--; // row number after which the new is to be inserted. should be incremented
	}
}

function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCount + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCount++;
	}
}

function AddRowsErm(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCountErm + 1);

		for(var j = 0; j < NUM_COLUMNS_ERM; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCountErm++;
	}
}

function UpdateRowNum(tableId, dataLen)
{
	g_OffSet = g_RowCount;
	AddRows(tableId, (dataLen - 1));
}

function UpdateErmRowNum(tableId, dataLen)
{
	g_OffSetErm = g_RowCountErm;
	AddRowsErm(tableId, (dataLen - 1));
}

function UpdateRowData(table, rowID, rowData)
{
	var row = rowID + g_OffSet;
	
	UpdatePidArrays((row - 2), rowData);// populates Int n Hex PID arrays

	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var textData = "";
		
		var cell = table.rows[row].cells[i];
		//cell.style.width = colWidth[i];
		
		if(i == INPUT_BUTTON)
		{
			stIndex[row - 1] = rowData[i];
			cell.innerHTML = "";
			textRow = document.createElement("input");
			textRow.type = "button";
			textRow.value= "Details";
			textRow.id = "Details" + (row);
//			textRow.onclick = MM_openBrWindow;
			cell.appendChild(textRow);
		}
		else
		{
			if(i == BITRATE_INDEX)
			{
				textData = parseFloat(rowData[i]).toFixed(4);
			}
			else
			{
				textData = rowData[i];
			}
			cell.innerHTML = textData;
		}
	}
}

function UpdateErmRowData(table, rowID, rowData)
{
	var row = rowID + g_OffSetErm;
	
	for(var i = 0; i < NUM_COLUMNS_ERM; i++)
	{
		var textData = "";
		
		var cell = table.rows[row].cells[i];
		cell.style.width = colWidthErm[i];
		
		if(i == 2)
		{
			textData = global_channel_index;
		}
		else
		{
			textData = rowData[i];
		}
		cell.innerHTML = textData;
	}
}

function UpdateTableData(tableId, outpResp)
{
	var dataLen = outpResp.length;
	var MeasRow;
	var table = document.getElementById(tableId);
	for(var i = 0; i < (dataLen - 1); i++)
	{
		MeasRow = outpResp[i];
		var rowData = MeasRow.split(",");
		UpdateRowData(table, (i + 1), rowData);
	}
}

function UpdateErmTableData(tableId, outpResp)
{
	var dataLen = outpResp.length;
	var ErmRow;
	var table = document.getElementById(tableId);
	for(var i = 0; i < (dataLen - 1); i++)
	{
		ErmRow = outpResp[i];
		var rowData = ErmRow.split(",");
		UpdateErmRowData(table, (i + 1), rowData);
	}
}

function PaintMeasTable(MeasTable)
{
	var dataLen = MeasTable.length;
	UpdateRowNum("MeasChTable",dataLen);
	UpdateTableData("MeasChTable",MeasTable);
	return true;
}

function PaintErmTable(ErmTable)
{
	var dataLen = ErmTable.length;
	UpdateErmRowNum("ErmChTable",dataLen);
	UpdateErmTableData("ErmChTable",ErmTable);
	return true;
}

function getElementId(Event)
{
    var elementId;
    if(window.event)
    {
       elementId = window.event.srcElement.id;
    }
    else
    {
        elementId = Event.target.id;
    }
    return elementId;
}

function MM_openBrWindow(e)
{
	var elemId = getElementId(e);
	var len = elemId.length;
	elemId = elemId.substring(7, len);
	theURL = "/fs/in_and_out.html?" + stIndex[elemId-1];
	winName = "";
	var features = "width=900,height=520,status,scrollbars,resizable=1";
	window.open(theURL, winName, features, (resizable = 1));
}

function TriggerPidsDisp(dispType,tableId)
{
	var table = document.getElementById(tableId);

	if(dispType == HEX_DISP)
	{
		for(var i = 0; i < (g_RowCount - 1); i++)
		{
			table.rows[i + 2].cells[PMT_PID].innerHTML = PmtPidHex[i];
			table.rows[i + 2].cells[PCR_PID].innerHTML = PcrPidHex[i];
		}
	}
	else if(dispType == INT_DISP)
	{
		for(var i = 0; i < (g_RowCount - 1); i++)
		{
			table.rows[i + 2].cells[PMT_PID].innerHTML = PmtPidInt[i];
			table.rows[i + 2].cells[PCR_PID].innerHTML = PcrPidInt[i];
		}
	}

}

function TogglePidsHexDisp()
{
	var dispType = 0;
	if((document.getElementById("HexDisplay")).checked)
	{
		dispType = HEX_DISP;
	}
	else
	{
		dispType = INT_DISP;
	}
	TriggerPidsDisp(dispType,"MeasChTable");
}

function UpdatePidArrays(rowIndex,rowData)
{
    var temp;
	if(rowData[PMT_PID] == "N/A")
	{
		PmtPidInt[rowIndex] = "N/A";
		PmtPidHex[rowIndex] = "N/A";
	}
	else
	{
		PmtPidInt[rowIndex] = rowData[PMT_PID];
		
		temp = parseInt(rowData[PMT_PID]);
		PmtPidHex[rowIndex] = "0x" + temp.toString(16);
	}
	if(rowData[PCR_PID] == "N/A")
	{
		PcrPidInt[rowIndex] = "N/A";
		PcrPidHex[rowIndex] = "N/A";
	}
	else
	{
		PcrPidInt[rowIndex] = rowData[PCR_PID];

		temp = parseInt(rowData[PCR_PID]);
		PcrPidHex[rowIndex] = "0x" + temp.toString(16);
	}
}

var row_index;
var init_row = true;
function GetMeasureChOutpData()
{
	var Response;
	var xmlhttp = getHTTPObject();
	
	if(init_row)
	{
		row_index = 0;
	}

	var getParam = "type=14&cmd=1" + "&channel=" + global_channel_index + "&row_index=" + row_index + "&language=" + language;

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParam.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				Response = gb2utf8(xmlhttp.responseBody);
				var index = Response.indexOf("</html>");
				var bias = Response.length - index;
				Response = Response.slice(7, - bias);
			}
			else
			{
				Response = xmlhttp.responseText.slice(7, -8);
			}
			var outpResp = Response.split("&");
			var outpLen = outpResp.length;
			PaintMeasTable(outpResp);

			init_row = false;
			
			if(outpResp[outpLen - 1].indexOf("row_index") != -1)
			{
				var cur_row_string = outpResp[outpLen - 1].split(",");
				row_index = cur_row_string[1];
			}

			if(outpResp[outpLen - 1] == "end")
			{
				init_row = true;
				GetErmChOutpData();
				return true;
			}
			setTimeout("GetMeasureChOutpData()", 5);
		}//if
	}
	xmlhttp.send(getParam);
}

var row_index_erm;
var init_row_erm = true;
function GetErmChOutpData()
{

	var xmlhttp = getHTTPObject();
	if(init_row_erm)
	{
		row_index_erm = 0;
	}

	var getParam = "type=14&cmd=1" + "&channel=" + global_channel_index + "&row_index=" + row_index_erm + "&getErm=1";

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParam.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var Response = xmlhttp.responseText;
			var outpResp = Response.slice(7, -8).split("&");
			var outpLen = outpResp.length;
			PaintErmTable(outpResp);

			init_row_erm = false;
			
			if(outpResp[outpLen - 1].indexOf("row_index") != -1)
			{
				var cur_row_string = outpResp[outpLen - 1].split(",");
				row_index_erm = cur_row_string[1];
			}

			if(outpResp[outpLen - 1] == "end")
			{
				init_row_erm = true;
				return true;
			}
			setTimeout("GetErmChOutpData()", 5);
		}//if
	}
	xmlhttp.send(getParam);
}

window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	port_index = parseInt(str[2]);
	channel_index = parseInt(str[3]);
	global_channel_index = card_index + "/" + port_index + "." + channel_index;
	language = document.getElementById("language").value;
	GetMeasureChOutpData();
}


